﻿$(document).ready(function () {
    // Add a summary row at the end of the table
    $('table.runningTotal').each(function () {
        var table = $(this);

        var numericOptions = $(":input.numericAnswer:not(.rankingItem)", table).first().autoNumeric("getSettings");
        $(".columnSummary", table).autoNumeric();
        if (numericOptions) {
            $(".columnSummary", table).autoNumeric("update", numericOptions);
        }

        // Gather information about columns element and store them by column for faster access
        var columns = {};
        $('[data-column-position] :input.numericAnswer', table).each(function () {
            var position = $(this).closest('[data-column-position]').attr('data-column-position');
            if (columns[position] === undefined) { columns[position] = []; }
            columns[position].push(this);
        });

        function columnChanged(position, validateBounds) {
            var sum = _.reduce($.map(columns[position], function (element) {
                var value = $(element).autoNumeric("get");
                if (!value) {
                    value = 0;
                }
                return parseFloat(value);
            }),
            function (accumulator, value) {
                return accumulator + value;
            }, 0);

            var summarySpan = $('[data-column-position=' + position + '] .columnSummary', table);

            if (isNaN(sum)) {
                summarySpan.text('');
            }
            else {
                if (columns[position][0]) {
                    //summarySpan.text($.fn.autoNumeric.Format($(columns[position][0]).attr("id"), sum));                    
                    summarySpan.autoNumeric("set", sum);
                }
                else {
                    summarySpan.text(sum);
                }
            }

            ValidateColumnBounds(position, sum, validateBounds);
        };

        function ValidateColumnBounds(position, sum, showMessages) {
            var summaryErrorRow = $('.summaryError', table);
            var errorCell = $('[data-column-position=' + position + ']', summaryErrorRow);
            var lowerBound = $('.lowerBoundError', errorCell);
            var upperBound = $('.upperBoundError', errorCell);

            summaryErrorRow.hide();
            lowerBound.hide();
            upperBound.hide();

            if (showMessages) {
                if (lowerBound.length > 0 && sum < parseFloat(lowerBound.attr("data-lowerbound"))) {
                    lowerBound.show();
                    summaryErrorRow.show();
                }
                else if (upperBound.length > 0 && sum > parseFloat(upperBound.attr("data-upperbound"))) {
                    upperBound.show();
                    summaryErrorRow.show();
                }
            }
        }

        function numberChanged() {
            var position = $(this).closest('[data-column-position]').attr('data-column-position');
            var hasValues = true;
            $.each(columns[position], function (index, input) {
                hasValues = hasValues && $(input).val() ? true : false;
            });
            columnChanged(position, hasValues);
        };

        $.each(columns, function (position, column) {
            var hasValues = false;
            $.each(column, function (index, input) {
                hasValues = hasValues || ($(input).val() && $(input).val() != $(input).attr("data-default-value")) ? true : false;
                $(input).on("blur", numberChanged);
            });
            columnChanged(position, hasValues);
        });

        //Set summary width equals input width
        $('.summary .columnSummary', table).each(function () {
            var cell = $(this).closest("td");
            var columnPosition = cell.attr("data-column-position");

            var tableRow = table.children("tbody").children("tr.gridRow").last();

            if (tableRow.length > 0) {
                var tableCell = $("td.gridItem[data-column-position='" + columnPosition + "']", tableRow);

                if (tableCell.length > 0) {
                    var control = $("table.control", tableCell);

                    if (control.length > 0) {
                        var rightLabelWidth = control.find("td.rightControls").width();

                        if (rightLabelWidth > 0) {
                            $(this).width(control.width() - (rightLabelWidth + 10));
                            $(this).css("padding-right", (rightLabelWidth + 10));
                        }
                        else {
                            $(this).width(control.find("input").width());
                        }
                    }
                }
            }
        });
    });

    $('div.runningTotal').each(function () {
        var runningTotal = $(this);

        $('.questionClearButton', runningTotal).on("click", function (e) {
            var questionContent = $(this).closest('.questionContent');

            $('input', $('table.runningTotal', runningTotal)).val('');
            $('.columnSummary', runningTotal).text('0');

            e.preventDefault();
        });
    });
});